#!/usr/bin/python
# -*- coding: utf-8 -*-
"""

harktool/utils/tsp.py

"""

import typing

import soundfile

import numpy


class TSP:
    @classmethod
    def load(cls, file: str | typing.BinaryIO) -> tuple[numpy.ndarray, int]:
        x, r = soundfile.read(file)
        return x, r

    @classmethod
    def save(cls, data: numpy.ndarray, sr: int, file: str | typing.BinaryIO) -> None:
        soundfile.write(file, data, sr)

# end of file
