#!/usr/bin/python
# -*- coding: utf-8 -*-
"""

harktool/utils/logger.py

"""

import logging

_logger = logging.getLogger('harktool')


class _CONFIG:
    _LOG_LEVELS = {
        'E': logging.ERROR,
        'I': logging.INFO,
        'W': logging.WARNING,
        'F': logging.FATAL,
        'D': logging.DEBUG,
    }

    _ARGS_KEYS_LOG_LEVEL = 'logLevel'
    _ARGS_KEYS_LOG_FILE = 'logFile'
    _ARGS_KEYS_LOG_FORMAT = 'logFormat'

    _DEFAULT_LOG_LEVEL = logging.INFO
    _DEFAULT_LOG_FILE = None
    _DEFAULT_LOG_FORMAT = '%(message)s'


def initialize_logger(args):
    level_name = getattr(args, _CONFIG._ARGS_KEYS_LOG_LEVEL, None)
    level = _CONFIG._LOG_LEVELS.get(level_name, _CONFIG._DEFAULT_LOG_LEVEL)
    _logger.setLevel(level)

    format = getattr(args, _CONFIG._ARGS_KEYS_LOG_FORMAT,
                     _CONFIG._DEFAULT_LOG_FORMAT)
    formatter = logging.Formatter(format)

    file = getattr(args, _CONFIG._ARGS_KEYS_LOG_FILE,
                   _CONFIG._DEFAULT_LOG_FILE)
    handler = logging.StreamHandler(file)
    handler.setFormatter(formatter)
    handler.setLevel(level)

    _logger.addHandler(handler)
    return _logger


def get_logger():
    return _logger

# end of file
