#!/usr/bin/python
# -*- coding: utf-8 -*-
"""

harktool/libharkio3/defs.py

"""

from enum import Enum

class StringEnum(str, Enum):
    pass

CoordinateSystem = StringEnum('CoordinateSystem', [(s, s.lower()) for s in [
                        'Unknown', 'Cartesian', 'Polar']])
UseTagType = StringEnum('UseTagType', ['NON_TAG', 'USE_TAG', 'ID_TAG'])
NeighborAlgorithm = StringEnum('NeighborAlgorithm', [(s, s) for s in ['Undefined', 'NearestNeighbor']])

DataType = StringEnum('DataType', [(s, s) for s in ['int32', 'float32', 'complex']])

# PositionsType = Enum('PositionsType', [(s, s) for s in [
#                      'tsp', 'impulse', 'noise', 'microphone', 'soundsource']])
PositionsType = StringEnum('PositionsType', [(s, s) for s in [
                     'tsp', 'impulse', 'noise', 'microphone', 'soundsource']])

# end of file
