#!/usr/bin/python
# -*- coding: utf-8 -*-
"""

harktool/app/main.py

"""
import argparse
import sys

from .error import HarkToolError
from . import calcsysimp, calctfgeo, calctfimp, calctfmouth, calctfrec

def parse_args(args):
    _app_description = 'HARKTOOL is a tool for visualization and generation of the transfer function.'
    _subapps = {
        'calctfimp': {'description': 'Generate transfer function from impulse responses', 'module': calctfimp},
        'calcsysimp': {'description': 'Calculate impluse responses from a recorded TSP wave', 'module': calcsysimp},
        'calctfgeo': {'description': 'Generate transfer function by geometric calculation', 'module': calctfgeo},
        'calctfrec': {'description': 'Generate transfer function from TSPs', 'module': calctfrec},
        'calctfmouth': {'description': 'Generate transfer function from mouth TSPs', 'module': calctfmouth},
    }

    parser = argparse.ArgumentParser(description=_app_description)
    subparsers = parser.add_subparsers()

    for key, config in _subapps.items():
        p = subparsers.add_parser(
            key, description=config['description'], help='see {} -h'.format(key))
        config['module'].setup_parser(p)

    return parser.parse_args(args)

def main(args=sys.argv[1:]):
    args = parse_args(args)

    if hasattr(args, 'handler'):
        args.handler(args)
    else:
        raise HarkToolError('Main Argument Error.  Use -h for help')

    
# end of file
