#! /usr/bin/env python3
# -*- coding: utf-8 -*-

import pickle
import queue
import sys
import threading

import kivy
import numpy
from kivy.app import App
from kivy.clock import Clock
from kivy.config import Config
from kivy.core.window import Window
from kivy.graphics import Color, Line, Rectangle, RenderContext
from kivy.graphics.texture import Texture
from kivy.lang import Builder
from kivy.properties import ObjectProperty
from kivy.uix.boxlayout import BoxLayout
from kivy.utils import get_color_from_hex as rgb
from kivy_garden.graph import Graph, LinePlot
from plotQuickImageGui import KivyImageGraph

kivy.require("1.8.0")
Config.set("kivy", "log_level", "error")
Config.set("kivy", "log_enable", "0")
Config.write()

BUF_SIZE = 10
q = queue.Queue(BUF_SIZE)


class KivyMusicSpecCodeGraph(KivyImageGraph):
    def __init__(self):
        super().__init__()
        self.flabel = "TF index"

    def do_plot(self):
        while True:
            try:
                dat = pickle.load(sys.stdin.buffer)
                q.put(dat)
            except EOFError:
                break

    def read_queue(self, dt):
        if q.empty():
            # print("empty")
            pass

        else:
            item = q.get()
            spectrum = numpy.array(item["spectrum"], dtype=numpy.float32)
            self.set_image(spectrum, offset=item["offset"])


class KivyMusicSpecCodeApp(App):
    def on_start(self):
        threading.Thread(target=self.root.do_plot).start()
        Clock.schedule_interval(self.root.read_queue, 0.001)

    def build(self):
        self.title = "plotQuickMusicSpec"
        return KivyMusicSpecCodeGraph()


if __name__ == "__main__":
    KivyMusicSpecCodeApp().run()
