#!/usr/bin/python
# -*- coding: utf-8 -*-
"""

harktool/app/utils.py

"""

import argparse

from ..libharkio3 import NeighborAlgorithm, Positions, UseTagType
from .defs import LogLevel, PositionType, TFType
from .error import HarkToolError


class StoreTFTypeAction(argparse.Action):
    def __call__(self, parser, namespace, values, option_string=None):
        outputType = {
            'LOC': TFType.LOC,
            'SEP': TFType.SEP,
            'LOC_SEP': TFType.LOC_SEP,
        }.get(values, None)
        if outputType is None:
            raise HarkToolError(
                'Unexpected output type: {}'.format(values))
        setattr(namespace, self.dest, values)

class StorePositionsTypeAction(argparse.Action):
    def __call__(self, parser, namespace, values, option_string=None):
        v = PositionType(values)
        setattr(namespace, self.dest, v)

class StoreLogLevelAction(argparse.Action):
    def __call__(self, parser, namespace, values, option_string=None):
        v = LogLevel(values)
        setattr(namespace, self.dest, v)

class StoreNeighborAlgorithmTypeAction(argparse.Action):
    def __call__(self, parser, namespace, values, option_string=None):
        v = NeighborAlgorithm(values)
        setattr(namespace, self.dest, v)

def select_output_channels(source_positions:Positions, microphone_positions:Positions) -> list[int]:
    ss = source_positions.positions
    ms = microphone_positions.positions
    if len(ms) > 0 and len(ss) > 0 and ss[0].channels_use == UseTagType.USE_TAG:
        return list(set(sum([sp.channels for sp in ss], [])))
    else:
        return list(range(len(ms)))

# end of file
