#!/usr/bin/python
# -*- coding: utf-8 -*-
"""

harktool/app/mergexmls.py

"""

import argparse
import sys

from .. import utils
from ..libharkio3 import HarkXML, HarkXMLParser
from .error import HarkToolError


def parse_args(args):
    parser = argparse.ArgumentParser(
        description='The command merges multiple xml files.')

    parser.add_argument('--output', '-o', type=str, metavar='PATH', dest='outfile',
                        help='Output file name. (with no output file, write result into stdout)')
    parser.add_argument('--last', '-l', action='store_true', dest='useLast', default=False,
                        help='Use the last argument specified when the nodes are duplicated')
    parser.add_argument('--logLevel', type=str, metavar='{E|W|I|D}', default='E',
                        required=False, help='Log information level. (default=%(default)s)', dest='logLevel')
    parser.add_argument(type=str, nargs='+', metavar='INFILE',
                        help='Input file name.', dest='infiles')

    return parser.parse_args(args)


def main(args=sys.argv[1:]):
    args = parse_args(args)

    logger = utils.initialize_logger(args)
    logger.info('Args: %s', args)
    
    xmldst = HarkXML()

    for infile in args.infiles:
        xmlsrc = HarkXMLParser.from_file(infile)

        if xmlsrc.positions is not None:
            if xmldst.positions is None or args.useLast:
                xmldst.positions = xmlsrc.positions

            else:
                raise HarkToolError('<positions> node duplicated.')

        if xmlsrc.config is not None:
            if xmldst.config is None or args.useLast:
                xmldst.config = xmlsrc.config

            else:
                raise HarkToolError('<config> node duplicated.')

        if xmlsrc.neighbors is not None:
            if xmldst.neighbors is None or args.useLast:
                xmldst.neighbors = xmlsrc.neighbors

            else:
                raise HarkToolError('<neighbors> node duplicated.')

    HarkXMLParser.as_file(xmldst, args.outfile)

    logger.debug('XML file created')


# end of file
