#! /usr/bin/env python3

import json
import os
import sys

import harklib
import numpy

import hark
import hark.base
import hark.node


class SaveSources(hark.node.PythonNode):
    def __init__(self):
        super().__init__(["SOURCES", "FILENAME"], "OUTPUT")
        self.filename = "sources.json"
        self.initialized = False
        self.sources = []
        self.count = 0

    def __del__(self):
        if self.filename and isinstance(self.filename, str):
            with open(self.filename, "w") as f:
                f.write(json.dumps(self.sources))

    def forward(self, **kwargs):
        if not self.initialized:
            if "FILENAME" in kwargs:
                if isinstance(kwargs["FILENAME"], str):
                    self.filename = kwargs["FILENAME"]
            self.initialized = True
        srcs = kwargs["SOURCES"]
        write_srcs = []
        if isinstance(srcs, list):
            for src in srcs:
                write_srcs.append({"id": src.id, "x": src.x})
        self.sources.append(write_srcs)
        self.count += 1
        return {"OUTPUT": kwargs["SOURCES"]}

