#! /usr/bin/env python3

import json
import os
import sys

import harklib
import numpy

import hark
import hark.base
import hark.node

from . import IFndjson as ndj

class SaveFrames(hark.node.PythonNode):
    def __init__(self):
        super().__init__(["INPUT", "FILENAME", "FILETYPE", "INTERVAL"], "OUTPUT")
        self.filename = "dumps.json"
        self.initialized = False
        self.input = []
        self.interval = 0 # 0: all frames, otherwise: N frame spacing.
        self.count = 0

    def __del__(self):
        if self.filename and isinstance(self.filename, str):
            with open(self.filename, "w") as f:
                f.write(json.dumps(self.input))

    def forward(self, **kwargs):
        if not self.initialized:
            if "FILENAME" in kwargs:
                if isinstance(kwargs["FILENAME"], str):
                    self.filename = kwargs["FILENAME"]
            if "INTERVAL" in kwargs:
                if isinstance(kwargs["INTERVAL"], int):
                    self.interval = kwargs["INTERVAL"] if (kwargs["INTERVAL"] > 0) else 0
            self.initialized = True
        srcs = kwargs["INPUT"]
        write_srcs = []
        if isinstance(srcs, list):
            for src in srcs:
                write_srcs.append({"id": src.id, "x": src.x})
        self.sources.append(write_srcs)
        self.count += 1
        return {"OUTPUT": kwargs["SOURCES"]}

