#! /usr/bin/env python3

import json
import os
import sys

import harklib
import numpy

import hark
import hark.base
import hark.node


class LoadSources(hark.node.PythonNode):
    def __init__(self):
        super().__init__(["SOURCES", "FILENAME"], "OUTPUT")
        self.filename = "sources.json"
        self.initialized = False
        self.sources = []
        self.count = 0

    def forward(self, **kwargs):
        if not self.initialized:
            if "FILENAME" in kwargs:
                if isinstance(kwargs["FILENAME"], str):
                    self.filename = kwargs["FILENAME"]
            if self.filename and isinstance(self.filename, str):
                with open(self.filename) as f:
                    self.sources = json.load(f)
            self.initialized = True
        srcs = []
        if len(self.sources) > self.count:
            if isinstance(self.sources[self.count], list):
                srcs = [harklib.base.Source() for src in self.sources[self.count]]
                for dest, src in zip(srcs, self.sources[self.count]):
                    dest.id = src["id"]
                    dest.x = src["x"]
        self.count += 1
        return {"OUTPUT": srcs}

