#! /usr/bin/env python3

import os
import sys

import numpy

import hark
import hark.base
import hark.node


class TensorToMap(hark.node.PythonNode):
    def __init__(self):
        # super().__init__(["INPUT", "AXIS"], ["OUTPUT"])
        super().__init__("INPUT", "OUTPUT")
        self.axis = 0

    def forward(self, **kwargs):
        ret = {}
        if isinstance(kwargs["INPUT"], numpy.ndarray) and kwargs["INPUT"].ndim > self.axis:
            if self.axis == 0:
                ret = {i: kwargs["INPUT"][i] for i in range(kwargs["INPUT"].shape[0])}
            elif self.axis == 1:
                ret = {i: kwargs["INPUT"][:,i] for i in range(kwargs["INPUT"].shape[1])}
            elif self.axis == 2:
                ret = {i: kwargs["INPUT"][:,:,i] for i in range(kwargs["INPUT"].shape[2])}
            elif self.axis == 3:
                ret = {i: kwargs["INPUT"][:,:,:,i] for i in range(kwargs["INPUT"].shape[3])}
            elif self.axis == 4:
                ret = {i: kwargs["INPUT"][:,:,:,:,i] for i in range(kwargs["INPUT"].shape[4])}
            elif self.axis == 5:
                ret = {i: kwargs["INPUT"][:,:,:,:,:,i] for i in range(kwargs["INPUT"].shape[5])}
            elif self.axis == 6:
                ret = {i: kwargs["INPUT"][:,:,:,:,:,:,i] for i in range(kwargs["INPUT"].shape[6])}
            else:
                print("This node supports tensors up to the rank 7. The input tensor has rank {}.".format(kwargs["INPUT"].ndim))
        elif isinstance(kwargs["INPUT"], numpy.ndarray) and kwargs["INPUT"].ndim == 0:
            ret = {0: kwargs["INPUT"]}

        return {"OUTPUT": ret}


class MatrixToMap(hark.node.PythonNode):
    def __init__(self):
        # super().__init__(["INPUT", "AXIS"], ["OUTPUT"])
        super().__init__("INPUT", "OUTPUT")
        # rows: axis=0, cols: axis=1
        self.axis = 0

    def forward(self, **kwargs):
        ret = {}
        if isinstance(kwargs["INPUT"], numpy.ndarray) and kwargs["INPUT"].ndim == 2:
            if self.axis == 0:
                ret = {i: kwargs["INPUT"][i] for i in range(kwargs["INPUT"].shape[0])}
            elif self.axis == 1:
                ret = {i: kwargs["INPUT"][:,i] for i in range(kwargs["INPUT"].shape[1])}
        elif isinstance(kwargs["INPUT"], list) and len(kwargs["INPUT"]) != 0:
            try:
                tmp = numpy.array(kwargs["INPUT"])
                if tmp.ndim == 2:
                    if self.axis == 0:
                        ret = {i: tmp[i] for i in range(tmp.shape[0])}
                    elif self.axis == 1:
                        ret = {i: tmp[:,i] for i in range(tmp.shape[1])}
            except ValueError:
                # Multidimensional lists (nested lists) that cannot be converted to
                # numpy.ndarray cannot guarantee that the axis sizes match.
                print("MatrixToMap node's input cannot be converted to numpy.ndarray().")
                pass

        return {"OUTPUT": ret}


class VectorToMap(hark.node.PythonNode):
    def __init__(self):
        # super().__init__(["INPUT"], ["OUTPUT"])
        super().__init__("INPUT", "OUTPUT")

    def forward(self, **kwargs):
        ret = {}
        if isinstance(kwargs["INPUT"], numpy.ndarray) and kwargs["INPUT"].ndim == 1:
            ret = {i: kwargs["INPUT"][i] for i in range(kwargs["INPUT"].shape[0])}
        elif isinstance(kwargs["INPUT"], list) and len(kwargs["INPUT"]) != 0:
            try:
                tmp = numpy.array(kwargs["INPUT"])
                if tmp.ndim == 1:
                    ret = {i: tmp[i] for i in range(tmp.shape[0])}
            except ValueError:
                # In the case of list input, it is always considered to be a value
                # even if the element contains a list.
                ret = {i: kwargs["INPUT"][i] for i in range(len(kwargs["INPUT"]))}

        return {"OUTPUT": ret}
